/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.storage.ITStorage;
import zipkin2.storage.StorageComponent;

public abstract class ITTraces<T extends StorageComponent>
extends ITStorage<T> {
    @Override
    protected final void configureStorageForTest(StorageComponent.Builder storage) {
    }

    @Test
    protected void getTrace_returnsEmptyOnNotFound() throws IOException {
        Assertions.assertThat((List)((List)this.traces().getTrace(TestObjects.CLIENT_SPAN.traceId()).execute())).isEmpty();
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.traces().getTrace(TestObjects.CLIENT_SPAN.traceId()).execute())).containsExactly((Object[])new Span[]{TestObjects.CLIENT_SPAN});
        Assertions.assertThat((List)((List)this.traces().getTrace(TestObjects.CLIENT_SPAN.traceId().substring(16)).execute())).isEmpty();
    }

    @Test
    protected void getTraces_onlyReturnsTracesThatMatch() throws IOException {
        List<String> traceIds = Arrays.asList(TestObjects.LOTS_OF_SPANS[0].traceId(), TestObjects.LOTS_OF_SPANS[1].traceId());
        Assertions.assertThat((List)((List)this.traces().getTraces(traceIds).execute())).isEmpty();
        this.accept(TestObjects.LOTS_OF_SPANS[0], TestObjects.LOTS_OF_SPANS[2]);
        Assertions.assertThat((List)((List)this.traces().getTraces(traceIds).execute())).containsOnly((Object[])new List[]{Arrays.asList(TestObjects.LOTS_OF_SPANS[0])});
        List longTraceIds = traceIds.stream().map(t -> "a" + t).collect(Collectors.toList());
        Assertions.assertThat((List)((List)this.traces().getTraces(longTraceIds).execute())).isEmpty();
    }

    @Test
    protected void getTraces_returnsEmptyOnNotFound() throws IOException {
        List<String> traceIds = Arrays.asList(TestObjects.LOTS_OF_SPANS[0].traceId(), TestObjects.LOTS_OF_SPANS[1].traceId());
        Assertions.assertThat((List)((List)this.traces().getTraces(traceIds).execute())).isEmpty();
        this.accept(TestObjects.LOTS_OF_SPANS[0], TestObjects.LOTS_OF_SPANS[1]);
        Assertions.assertThat((List)((List)this.traces().getTraces(traceIds).execute())).containsExactlyInAnyOrder((Object[])new List[]{Arrays.asList(TestObjects.LOTS_OF_SPANS[0]), Arrays.asList(TestObjects.LOTS_OF_SPANS[1])});
        List longTraceIds = traceIds.stream().map(t -> "a" + t).collect(Collectors.toList());
        Assertions.assertThat((List)((List)this.traces().getTraces(longTraceIds).execute())).isEmpty();
    }

    @Test
    protected void getTrace_deduplicates() throws IOException {
        this.accept(TestObjects.LOTS_OF_SPANS[0]);
        this.accept(TestObjects.LOTS_OF_SPANS[0]);
        Assertions.assertThat(ITTraces.sortTrace((List)this.traces().getTrace(TestObjects.LOTS_OF_SPANS[0].traceId()).execute())).containsExactly((Object[])new Span[]{TestObjects.LOTS_OF_SPANS[0]});
    }
}

