/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.storage.ITSpanStore;
import zipkin2.storage.ITStorage;
import zipkin2.storage.StorageComponent;

public abstract class ITStrictTraceIdFalse<T extends StorageComponent>
extends ITStorage<T> {
    Span with128BitId1 = Span.newBuilder().traceId("baaaaaaaaaaaaaaaa").id("a").timestamp(TestObjects.TODAY * 1000L).build();
    Span with64BitId1 = Span.newBuilder().traceId("aaaaaaaaaaaaaaaa").id("b").timestamp((TestObjects.TODAY + 1L) * 1000L).build();
    Span with128BitId2 = Span.newBuilder().traceId("21111111111111111").id("1").timestamp(TestObjects.TODAY * 1000L).build();
    Span with64BitId2 = Span.newBuilder().traceId("1111111111111111").id("2").timestamp((TestObjects.TODAY + 1L) * 1000L).build();
    Span with128BitId3 = Span.newBuilder().traceId("effffffffffffffff").id("1").timestamp(TestObjects.TODAY * 1000L).build();
    Span with64BitId3 = Span.newBuilder().traceId("ffffffffffffffff").id("2").timestamp(TestObjects.TODAY * 1000L).build();

    @Override
    protected final void configureStorageForTest(StorageComponent.Builder storage) {
        storage.strictTraceId(false);
    }

    @Test
    protected void getTraces_128BitTraceId() throws IOException {
        this.getTraces_128BitTraceId(this.accept128BitTrace(this.storage));
    }

    @Test
    protected void getTraces_128BitTraceId_mixed() throws IOException {
        this.getTraces_128BitTraceId(this.acceptMixedTrace());
    }

    protected void getTraces_128BitTraceId(List<Span> trace) throws IOException {
        Assertions.assertThat(ITStrictTraceIdFalse.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().build()).execute())).containsExactly((Object[])new List[]{trace});
        Assertions.assertThat(ITStrictTraceIdFalse.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName(TestObjects.FRONTEND.serviceName()).parseAnnotationQuery("foo").build()).execute())).containsExactly((Object[])new List[]{trace});
        Assertions.assertThat(ITStrictTraceIdFalse.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName(TestObjects.BACKEND.serviceName()).parseAnnotationQuery("error").build()).execute())).containsExactly((Object[])new List[]{trace});
    }

    @Test
    protected void getTrace_retrievesBy64Or128BitTraceId() throws IOException {
        List<Span> trace = this.accept128BitTrace(this.storage);
        this.retrievesBy64Or128BitTraceId(trace);
    }

    @Test
    protected void getTrace_retrievesBy64Or128BitTraceId_mixed() throws IOException {
        List<Span> trace = this.acceptMixedTrace();
        this.retrievesBy64Or128BitTraceId(trace);
    }

    void retrievesBy64Or128BitTraceId(List<Span> trace) throws IOException {
        String traceId = trace.get(trace.size() - 1).traceId();
        Assertions.assertThat((List)((List)this.traces().getTrace(traceId.substring(16)).execute())).containsExactlyInAnyOrderElementsOf(trace);
        Assertions.assertThat((List)((List)this.traces().getTrace(traceId).execute())).containsExactlyInAnyOrderElementsOf(trace);
    }

    protected List<Span> accept128BitTrace(StorageComponent storage) throws IOException {
        ArrayList<Span> trace = new ArrayList<Span>(TestObjects.TRACE);
        Collections.reverse(trace);
        storage.spanConsumer().accept(trace).execute();
        return TestObjects.TRACE;
    }

    List<Span> acceptMixedTrace() throws IOException {
        ArrayList<Span> trace = new ArrayList<Span>(TestObjects.TRACE);
        String downgraded = ((Span)trace.get(0)).traceId().substring(16);
        for (int i = 2; i < trace.size(); ++i) {
            trace.set(i, ((Span)trace.get(i)).toBuilder().traceId(downgraded).build());
        }
        Collections.reverse(trace);
        this.accept(trace.toArray(new Span[0]));
        return ITStrictTraceIdFalse.sortTrace(trace);
    }

    @Test
    protected void getTraces_retrievesBy64Or128BitTraceId() throws Exception {
        this.accept(this.with128BitId1, this.with64BitId1, this.with128BitId2, this.with64BitId2, this.with128BitId3, this.with64BitId3);
        List<List> trace1And3 = Arrays.asList(Arrays.asList(this.with128BitId1, this.with64BitId1), Arrays.asList(this.with128BitId3, this.with64BitId3));
        List<List<Span>> resultsWithBothIdLength = ITStrictTraceIdFalse.sortTraces((List)this.traces().getTraces(Arrays.asList(this.with128BitId1.traceId(), this.with64BitId1.traceId(), this.with128BitId3.traceId(), this.with64BitId3.traceId())).execute());
        Assertions.assertThat(resultsWithBothIdLength).containsExactlyElementsOf(trace1And3);
        List<List<Span>> resultsWith64BitIdLength = ITStrictTraceIdFalse.sortTraces((List)this.traces().getTraces(Arrays.asList(this.with64BitId1.traceId(), this.with64BitId3.traceId())).execute());
        Assertions.assertThat(resultsWith64BitIdLength).containsExactlyElementsOf(trace1And3);
        List<List<Span>> resultsWith128BitIdLength = ITStrictTraceIdFalse.sortTraces((List)this.traces().getTraces(Arrays.asList(this.with128BitId1.traceId(), this.with128BitId3.traceId())).execute());
        Assertions.assertThat(resultsWith128BitIdLength).containsExactlyElementsOf(trace1And3);
    }
}

