/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import zipkin2.Annotation;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.internal.Trace;
import zipkin2.storage.ITStorage;
import zipkin2.storage.QueryRequest;
import zipkin2.storage.StorageComponent;

public abstract class ITSpanStore<T extends StorageComponent>
extends ITStorage<T> {
    @Override
    protected final void configureStorageForTest(StorageComponent.Builder storage) {
    }

    @Test
    protected void allShouldWorkWhenEmpty() throws IOException {
        QueryRequest.Builder q = ITSpanStore.requestBuilder().serviceName("service");
        Assertions.assertThat((List)((List)this.store().getTraces(q.build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(q.remoteServiceName("remotey").build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(q.spanName("methodcall").build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(q.parseAnnotationQuery("custom").build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(q.parseAnnotationQuery("BAH=BEH").build()).execute())).isEmpty();
    }

    @Test
    protected void allShouldWorkWhenNoIndexableDataYet() throws IOException {
        this.accept(Span.newBuilder().traceId("1").id("1").build());
        this.allShouldWorkWhenEmpty();
    }

    @Test
    protected void consumer_properlyImplementsCallContract_execute() throws IOException {
        Call call = this.storage.spanConsumer().accept(Arrays.asList(TestObjects.LOTS_OF_SPANS[0]));
        Assertions.assertThat((List)((List)this.traces().getTrace(TestObjects.LOTS_OF_SPANS[0].traceId()).execute())).isEmpty();
        call.execute();
        Assertions.assertThat((List)((List)this.traces().getTrace(TestObjects.LOTS_OF_SPANS[0].traceId()).execute())).containsExactly((Object[])new Span[]{TestObjects.LOTS_OF_SPANS[0]});
        try {
            call.execute();
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        call.clone().execute();
    }

    @Test
    protected void consumer_properlyImplementsCallContract_submit() throws Exception {
        Call call = this.storage.spanConsumer().accept(Arrays.asList(TestObjects.LOTS_OF_SPANS[0]));
        Assertions.assertThat((List)((List)this.traces().getTrace(TestObjects.LOTS_OF_SPANS[0].traceId()).execute())).isEmpty();
        final CountDownLatch latch = new CountDownLatch(1);
        Callback<Void> callback = new Callback<Void>(){

            public void onSuccess(Void value) {
                latch.countDown();
            }

            public void onError(Throwable t) {
                latch.countDown();
            }
        };
        call.enqueue((Callback)callback);
        latch.await();
        Assertions.assertThat((List)((List)this.traces().getTrace(TestObjects.LOTS_OF_SPANS[0].traceId()).execute())).containsExactly((Object[])new Span[]{TestObjects.LOTS_OF_SPANS[0]});
        try {
            call.enqueue((Callback)callback);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        call.clone().execute();
    }

    @Test
    protected void getTraces_groupsTracesTogether() throws IOException {
        Span traceASpan1 = Span.newBuilder().traceId("a").id("1").timestamp((TestObjects.TODAY + 1L) * 1000L).localEndpoint(TestObjects.FRONTEND).build();
        Span traceASpan2 = traceASpan1.toBuilder().id("2").timestamp((TestObjects.TODAY + 2L) * 1000L).build();
        Span traceBSpan1 = traceASpan1.toBuilder().traceId("b").build();
        Span traceBSpan2 = traceASpan2.toBuilder().traceId("b").build();
        this.accept(traceASpan1, traceBSpan1, traceASpan2, traceBSpan2);
        Assertions.assertThat(ITSpanStore.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().build()).execute())).containsExactlyInAnyOrder((Object[])new List[]{Arrays.asList(traceASpan1, traceASpan2), Arrays.asList(traceBSpan1, traceBSpan2)});
    }

    @Test
    protected void getTraces_considersBitsAbove64bit() throws IOException {
        Span span1 = Span.newBuilder().traceId(TestObjects.CLIENT_SPAN.traceId().substring(16)).id("1").putTag("foo", "1").timestamp(TestObjects.TODAY * 1000L).localEndpoint(TestObjects.FRONTEND).build();
        Span span2 = span1.toBuilder().traceId(TestObjects.CLIENT_SPAN.traceId()).putTag("foo", "2").build();
        Span span3 = span1.toBuilder().traceId("1" + span1.traceId()).putTag("foo", "3").build();
        this.accept(span1, span2, span3);
        for (Span span : Arrays.asList(span1, span2, span3)) {
            Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("frontend").parseAnnotationQuery("foo=" + (String)span.tags().get("foo")).build()).execute())).flatExtracting(t -> t).containsExactly((Object[])new Span[]{span});
        }
    }

    @Test
    protected void getTraces_filteringMatchesMostRecentTraces() throws Exception {
        List endpoints = IntStream.rangeClosed(1, 10).mapToObj(i -> Endpoint.newBuilder().serviceName("service" + i).ip("127.0.0.1").build()).collect(Collectors.toList());
        long gapBetweenSpans = 100L;
        Span[] earlySpans = (Span[])IntStream.rangeClosed(1, 10).mapToObj(i -> Span.newBuilder().name("early").traceId(Integer.toHexString(i)).id(Integer.toHexString(i)).timestamp((TestObjects.TODAY - (long)i) * 1000L).duration(1L).localEndpoint((Endpoint)endpoints.get(i - 1)).build()).toArray(Span[]::new);
        Span[] lateSpans = (Span[])IntStream.rangeClosed(1, 10).mapToObj(i -> Span.newBuilder().name("late").traceId(Integer.toHexString(i + 10)).id(Integer.toHexString(i + 10)).timestamp((TestObjects.TODAY + gapBetweenSpans - (long)i) * 1000L).duration(1L).localEndpoint((Endpoint)endpoints.get(i - 1)).build()).toArray(Span[]::new);
        this.accept(earlySpans);
        this.accept(lateSpans);
        Object[] earlyTraces = (List[])Stream.of(earlySpans).map(Collections::singletonList).toArray(List[]::new);
        Object[] lateTraces = (List[])Stream.of(lateSpans).map(Collections::singletonList).toArray(List[]::new);
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().build()).execute())).hasSize(20);
        Assertions.assertThat(ITSpanStore.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().limit(10).build()).execute())).containsExactly(lateTraces);
        Assertions.assertThat(ITSpanStore.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY + gapBetweenSpans).lookback(gapBetweenSpans).build()).execute())).containsExactly(lateTraces);
        Assertions.assertThat(ITSpanStore.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY).build()).execute())).containsExactly(earlyTraces);
    }

    @Test
    protected void getTraces_serviceNames() throws Exception {
        this.accept(TestObjects.CLIENT_SPAN);
        ((ListAssert)Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("frontend1").build()).execute())).withFailMessage("Results matched even with invalid service name", new Object[0])).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("frontend").build()).execute())).flatExtracting(l -> l).contains((Object[])new Span[]{TestObjects.CLIENT_SPAN});
        ((ListAssert)Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName(TestObjects.CLIENT_SPAN.localServiceName()).remoteServiceName(TestObjects.CLIENT_SPAN.remoteServiceName() + 1).build()).execute())).withFailMessage("Results matched even with invalid remote service name", new Object[0])).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName(TestObjects.CLIENT_SPAN.localServiceName()).remoteServiceName(TestObjects.CLIENT_SPAN.remoteServiceName()).build()).execute())).flatExtracting(l -> l).contains((Object[])new Span[]{TestObjects.CLIENT_SPAN});
    }

    @Test
    protected void getTraces_serviceNames_mixedTraceIdLength() throws Exception {
        this.accept(TestObjects.CLIENT_SPAN.toBuilder().traceId(TestObjects.CLIENT_SPAN.traceId().substring(16)).localEndpoint(Endpoint.newBuilder().serviceName("foo").build()).remoteEndpoint(Endpoint.newBuilder().serviceName("bar").build()).build());
        this.getTraces_serviceNames();
    }

    @Test
    protected void getTraces_spanName() throws Exception {
        this.accept(TestObjects.CLIENT_SPAN);
        ((ListAssert)Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().spanName(TestObjects.CLIENT_SPAN.name() + 1).build()).execute())).withFailMessage("Results matched with an invalid span name", new Object[0])).isEmpty();
        ((ListAssert)Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName(TestObjects.CLIENT_SPAN.localServiceName()).spanName(TestObjects.CLIENT_SPAN.name() + 1).build()).execute())).withFailMessage("Results matched with a value service name, but an invalid span name", new Object[0])).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().spanName(TestObjects.CLIENT_SPAN.name()).build()).execute())).flatExtracting(l -> l).contains((Object[])new Span[]{TestObjects.CLIENT_SPAN});
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName(TestObjects.CLIENT_SPAN.localServiceName()).spanName(TestObjects.CLIENT_SPAN.name()).build()).execute())).flatExtracting(l -> l).contains((Object[])new Span[]{TestObjects.CLIENT_SPAN});
    }

    @Test
    protected void getTraces_spanName_mixedTraceIdLength() throws Exception {
        this.accept(TestObjects.CLIENT_SPAN.toBuilder().traceId(TestObjects.CLIENT_SPAN.traceId().substring(16)).name("bar").build());
        this.getTraces_spanName();
    }

    @Test
    protected void getTraces_tags() throws Exception {
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().annotationQuery(Collections.singletonMap("foo", "bar")).build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().annotationQuery(TestObjects.CLIENT_SPAN.tags()).build()).execute())).flatExtracting(l -> l).contains((Object[])new Span[]{TestObjects.CLIENT_SPAN});
    }

    @Test
    protected void getTraces_minDuration() throws Exception {
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().minDuration(Long.valueOf(TestObjects.CLIENT_SPAN.durationAsLong() + 1L)).build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().minDuration(Long.valueOf(TestObjects.CLIENT_SPAN.durationAsLong())).build()).execute())).flatExtracting(l -> l).contains((Object[])new Span[]{TestObjects.CLIENT_SPAN});
    }

    @Test
    protected void getTraces_lateDuration() throws Exception {
        Span missingDuration = TestObjects.CLIENT_SPAN.toBuilder().duration(0L).build();
        Span lateDuration = Span.newBuilder().traceId(TestObjects.CLIENT_SPAN.traceId()).id(TestObjects.CLIENT_SPAN.id()).timestamp(TestObjects.CLIENT_SPAN.timestampAsLong()).duration(TestObjects.CLIENT_SPAN.durationAsLong()).localEndpoint(TestObjects.CLIENT_SPAN.localEndpoint()).build();
        this.accept(missingDuration);
        this.accept(lateDuration);
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().minDuration(Long.valueOf(TestObjects.CLIENT_SPAN.durationAsLong() + 1L)).build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().minDuration(Long.valueOf(TestObjects.CLIENT_SPAN.durationAsLong())).build()).execute())).flatExtracting(Trace::merge).containsExactly((Object[])new Span[]{TestObjects.CLIENT_SPAN});
    }

    @Test
    protected void getTraces_maxDuration() throws Exception {
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().minDuration(Long.valueOf(TestObjects.CLIENT_SPAN.durationAsLong() - 2L)).maxDuration(Long.valueOf(TestObjects.CLIENT_SPAN.durationAsLong() - 1L)).build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().minDuration(Long.valueOf(TestObjects.CLIENT_SPAN.durationAsLong())).maxDuration(Long.valueOf(TestObjects.CLIENT_SPAN.durationAsLong())).build()).execute())).flatExtracting(l -> l).contains((Object[])new Span[]{TestObjects.CLIENT_SPAN});
    }

    @Test
    protected void readback_minimalErrorSpan() throws Exception {
        String serviceName = "isao01";
        Span errorSpan = Span.newBuilder().traceId("dc955a1d4768875d").id("dc955a1d4768875d").timestamp(TestObjects.TODAY * 1000L).localEndpoint(Endpoint.newBuilder().serviceName(serviceName).build()).kind(Span.Kind.CLIENT).putTag("error", "").build();
        this.accept(errorSpan);
        QueryRequest.Builder requestBuilder = ITSpanStore.requestBuilder().serviceName(serviceName);
        Assertions.assertThat((List)((List)this.store().getTraces(requestBuilder.build()).execute())).flatExtracting(l -> l).contains((Object[])new Span[]{errorSpan});
        Assertions.assertThat((List)((List)this.store().getTraces(requestBuilder.parseAnnotationQuery("error").build()).execute())).flatExtracting(l -> l).contains((Object[])new Span[]{errorSpan});
        Assertions.assertThat((List)((List)this.store().getTraces(requestBuilder.parseAnnotationQuery("error=1").build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.traces().getTrace(errorSpan.traceId()).execute())).contains((Object[])new Span[]{errorSpan});
    }

    @Test
    protected void readsBackLargeValues() throws IOException {
        char[] kilobyteOfText = new char[1024];
        Arrays.fill(kilobyteOfText, 'a');
        Span span = Span.newBuilder().traceId("1").id("1").name("big").timestamp(TestObjects.TODAY * 1000L + 100L).duration(200L).localEndpoint(TestObjects.FRONTEND).putTag("a", new String(kilobyteOfText)).build();
        this.accept(span);
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().build()).execute())).containsExactly((Object[])new List[]{Arrays.asList(span)});
        Assertions.assertThat((List)((List)this.traces().getTrace(span.traceId()).execute())).containsExactly((Object[])new Span[]{span});
    }

    @Test
    protected void spanWithProblematicData() throws IOException {
        Span part1 = Span.newBuilder().traceId("a").id("b").timestamp((TestObjects.TODAY + 50L) * 1000L).localEndpoint(TestObjects.FRONTEND).putTag("http.path", "/api").build();
        this.accept(part1);
        String json = "{\"foo\":\"bar\"}";
        Span part2 = part1.toBuilder().name(json).clearTags().putTag("http.path.morepath", "/api/api").build();
        this.accept(part2);
        Span merged = (Span)Trace.merge(Arrays.asList(part1, part2)).get(0);
        QueryRequest query = ITSpanStore.requestBuilder().serviceName("frontend").spanName(json).build();
        Assertions.assertThat((List)((List)this.store().getTraces(query).execute())).flatExtracting(Trace::merge).containsExactly((Object[])new Span[]{merged});
        Assertions.assertThat((List)((List)this.traces().getTrace(part1.traceId()).map(Trace::merge).execute())).containsExactly((Object[])new Span[]{merged});
    }

    @Test
    protected void getTraces_manyTraces() throws IOException {
        int traceCount = 1000;
        Span span = TestObjects.LOTS_OF_SPANS[0];
        Map.Entry tag = span.tags().entrySet().iterator().next();
        this.accept(Arrays.copyOfRange(TestObjects.LOTS_OF_SPANS, 0, traceCount));
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().limit(traceCount).build()).execute())).hasSize(traceCount);
        QueryRequest.Builder builder = ITSpanStore.requestBuilder().limit(traceCount).serviceName(span.localServiceName());
        Assertions.assertThat((List)((List)this.store().getTraces(builder.build()).execute())).hasSize(traceCount);
        Assertions.assertThat((List)((List)this.store().getTraces(builder.remoteServiceName(span.remoteServiceName()).build()).execute())).hasSize(traceCount);
        Assertions.assertThat((List)((List)this.store().getTraces(builder.spanName(span.name()).build()).execute())).hasSize(traceCount);
        Assertions.assertThat((List)((List)this.store().getTraces(builder.parseAnnotationQuery((String)tag.getKey() + "=" + (String)tag.getValue()).build()).execute())).hasSize(traceCount);
    }

    @Test
    protected void getTraces_duration() throws IOException {
        this.setupDurationData();
        QueryRequest.Builder q = ITSpanStore.requestBuilder().endTs(TestObjects.TODAY).lookback(TestObjects.DAY);
        QueryRequest query = q.serviceName("service1").minDuration(Long.valueOf(200000L)).build();
        Assertions.assertThat((List)((List)this.store().getTraces(query).execute())).extracting(t -> ((Span)t.get(0)).traceId()).containsExactly((Object[])new String[]{"0000000000000001"});
        query = q.serviceName("service3").minDuration(Long.valueOf(200000L)).build();
        Assertions.assertThat((List)((List)this.store().getTraces(query).execute())).extracting(t -> ((Span)t.get(0)).traceId()).containsExactly((Object[])new String[]{"0000000000000002"});
        query = q.serviceName("service2").minDuration(Long.valueOf(50000L)).maxDuration(Long.valueOf(150000L)).build();
        Assertions.assertThat((List)((List)this.store().getTraces(query).execute())).extracting(t -> ((Span)t.get(0)).traceId()).containsExactlyInAnyOrder((Object[])new String[]{"0000000000000003", "0000000000000002", "0000000000000001"});
        query = q.serviceName("service1").remoteServiceName("service2").maxDuration(Long.valueOf(50000L)).build();
        Assertions.assertThat((List)((List)this.store().getTraces(query).execute())).extracting(t -> ((Span)t.get(0)).traceId()).containsExactly((Object[])new String[]{"0000000000000002"});
        query = q.serviceName("service2").spanName("zip").maxDuration(Long.valueOf(50000L)).build();
        Assertions.assertThat((List)((List)this.store().getTraces(query).execute())).extracting(t -> ((Span)t.get(0)).traceId()).containsExactly((Object[])new String[]{"0000000000000003"});
        query = q.serviceName("service2").minDuration(Long.valueOf(50000L)).maxDuration(Long.valueOf(50000L)).build();
        Assertions.assertThat((List)((List)this.store().getTraces(query).execute())).extracting(t -> ((Span)t.get(0)).traceId()).containsExactly((Object[])new String[]{"0000000000000003"});
    }

    @Test
    protected void getTraces_absentWhenNoTimestamp() throws IOException {
        this.accept(Span.newBuilder().traceId(TestObjects.CLIENT_SPAN.traceId()).id(TestObjects.CLIENT_SPAN.id()).name(TestObjects.CLIENT_SPAN.name()).localEndpoint(TestObjects.CLIENT_SPAN.localEndpoint()).build());
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName(TestObjects.CLIENT_SPAN.localServiceName()).build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName(TestObjects.CLIENT_SPAN.localServiceName()).spanName(TestObjects.CLIENT_SPAN.remoteServiceName()).build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName(TestObjects.CLIENT_SPAN.localServiceName()).spanName(TestObjects.CLIENT_SPAN.name()).build()).execute())).isEmpty();
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName(TestObjects.CLIENT_SPAN.localServiceName()).build()).execute())).isNotEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName(TestObjects.CLIENT_SPAN.localServiceName()).remoteServiceName(TestObjects.CLIENT_SPAN.remoteServiceName()).build()).execute())).isNotEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName(TestObjects.CLIENT_SPAN.localServiceName()).spanName(TestObjects.CLIENT_SPAN.name()).build()).execute())).isNotEmpty();
    }

    @Test
    protected void getTraces_annotation() throws IOException {
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("frontend").parseAnnotationQuery(((Annotation)TestObjects.CLIENT_SPAN.annotations().get(0)).value()).build()).execute())).isNotEmpty();
        Map.Entry tag = TestObjects.CLIENT_SPAN.tags().entrySet().iterator().next();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("frontend").parseAnnotationQuery((String)tag.getKey() + "=" + (String)tag.getValue()).build()).execute())).isNotEmpty();
    }

    @Test
    protected void getTraces_multipleAnnotationsBecomeAndFilter() throws IOException {
        Span foo = Span.newBuilder().traceId("1").name("call1").id(1L).timestamp((TestObjects.TODAY + 1L) * 1000L).localEndpoint(TestObjects.FRONTEND).addAnnotation((TestObjects.TODAY + 1L) * 1000L, "foo").build();
        Span barAndFoo = Span.newBuilder().traceId("2").name("call2").id(2L).timestamp((TestObjects.TODAY + 2L) * 1000L).localEndpoint(TestObjects.FRONTEND).addAnnotation((TestObjects.TODAY + 2L) * 1000L, "bar").addAnnotation((TestObjects.TODAY + 2L) * 1000L, "foo").build();
        Span fooAndBazAndQux = Span.newBuilder().traceId("3").name("call3").id(3L).timestamp((TestObjects.TODAY + 3L) * 1000L).localEndpoint(TestObjects.FRONTEND).addAnnotation((TestObjects.TODAY + 3L) * 1000L, "foo").putTag("baz", "qux").build();
        Span barAndFooAndBazAndQux = Span.newBuilder().traceId("4").name("call4").id(4L).timestamp((TestObjects.TODAY + 4L) * 1000L).localEndpoint(TestObjects.FRONTEND).addAnnotation((TestObjects.TODAY + 4L) * 1000L, "bar").addAnnotation((TestObjects.TODAY + 4L) * 1000L, "foo").putTag("baz", "qux").build();
        this.accept(foo, barAndFoo, fooAndBazAndQux, barAndFooAndBazAndQux);
        Assertions.assertThat(ITSpanStore.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("frontend").parseAnnotationQuery("foo").build()).execute())).containsExactly((Object[])new List[]{Arrays.asList(foo), Arrays.asList(barAndFoo), Arrays.asList(fooAndBazAndQux), Arrays.asList(barAndFooAndBazAndQux)});
        Assertions.assertThat(ITSpanStore.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("frontend").parseAnnotationQuery("foo and bar").build()).execute())).containsExactly((Object[])new List[]{Arrays.asList(barAndFoo), Arrays.asList(barAndFooAndBazAndQux)});
        Assertions.assertThat(ITSpanStore.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("frontend").parseAnnotationQuery("foo and bar and baz=qux").build()).execute())).containsExactly((Object[])new List[]{Arrays.asList(barAndFooAndBazAndQux)});
        Assertions.assertThat(ITSpanStore.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("frontend").parseAnnotationQuery("baz").build()).execute())).containsExactly((Object[])new List[]{Arrays.asList(fooAndBazAndQux), Arrays.asList(barAndFooAndBazAndQux)});
    }

    @Test
    protected void getTraces_differentiateOnServiceName() throws IOException {
        Span trace1 = Span.newBuilder().traceId("1").name("1").id(1L).kind(Span.Kind.CLIENT).timestamp((TestObjects.TODAY + 1L) * 1000L).duration(3000L).localEndpoint(TestObjects.FRONTEND).addAnnotation((TestObjects.TODAY + 1L) * 1000L + 500L, "web").putTag("local", "web").putTag("web-b", "web").build();
        Span trace1Server = Span.newBuilder().traceId("1").name("1").id(1L).kind(Span.Kind.SERVER).shared(true).localEndpoint(TestObjects.BACKEND).timestamp((TestObjects.TODAY + 2L) * 1000L).duration(1000L).build();
        Span trace2 = Span.newBuilder().traceId("2").name("2").id(2L).timestamp((TestObjects.TODAY + 11L) * 1000L).duration(3000L).kind(Span.Kind.CLIENT).localEndpoint(TestObjects.BACKEND).addAnnotation((TestObjects.TODAY + 11L) * 1000L + 500L, "app").putTag("local", "app").putTag("app-b", "app").build();
        Span trace2Server = Span.newBuilder().traceId("2").name("2").id(2L).shared(true).kind(Span.Kind.SERVER).localEndpoint(TestObjects.FRONTEND).timestamp((TestObjects.TODAY + 12L) * 1000L).duration(1000L).build();
        this.accept(trace1, trace1Server, trace2, trace2Server);
        Assertions.assertThat((List)((List)this.traces().getTrace(trace1.traceId()).execute())).containsExactlyInAnyOrder((Object[])new Span[]{trace1, trace1Server});
        Assertions.assertThat(ITSpanStore.sortTrace((List)this.traces().getTrace(trace2.traceId()).execute())).containsExactly((Object[])new Span[]{trace2, trace2Server});
        Assertions.assertThat(ITSpanStore.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().build()).execute())).containsExactly((Object[])new List[]{Arrays.asList(trace1, trace1Server), Arrays.asList(trace2, trace2Server)});
        Assertions.assertThat(ITSpanStore.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("frontend").parseAnnotationQuery("web").build()).execute())).containsExactly((Object[])new List[]{Arrays.asList(trace1, trace1Server)});
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("backend").parseAnnotationQuery("web").build()).execute())).isEmpty();
        Assertions.assertThat(ITSpanStore.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("backend").parseAnnotationQuery("app").build()).execute())).containsExactly((Object[])new List[]{Arrays.asList(trace2, trace2Server)});
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("frontend").parseAnnotationQuery("app").build()).execute())).isEmpty();
        Assertions.assertThat(ITSpanStore.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("frontend").parseAnnotationQuery("web-b").build()).execute())).containsExactly((Object[])new List[]{Arrays.asList(trace1, trace1Server)});
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("backend").parseAnnotationQuery("web-b").build()).execute())).isEmpty();
        Assertions.assertThat(ITSpanStore.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("backend").parseAnnotationQuery("app-b").build()).execute())).containsExactly((Object[])new List[]{Arrays.asList(trace2, trace2Server)});
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("frontend").parseAnnotationQuery("app-b").build()).execute())).isEmpty();
        Assertions.assertThat(ITSpanStore.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("frontend").parseAnnotationQuery("local=web").build()).execute())).containsExactly((Object[])new List[]{Arrays.asList(trace1, trace1Server)});
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("backend").parseAnnotationQuery("local=web").build()).execute())).isEmpty();
        Assertions.assertThat(ITSpanStore.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("backend").parseAnnotationQuery("local=app").build()).execute())).containsExactly((Object[])new List[]{Arrays.asList(trace2, trace2Server)});
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("frontend").parseAnnotationQuery("local=app").build()).execute())).isEmpty();
    }

    @Test
    protected void getTraces_limit() throws IOException {
        Span span1 = Span.newBuilder().traceId("a").id("1").timestamp((TestObjects.TODAY + 1L) * 1000L).localEndpoint(TestObjects.FRONTEND).build();
        Span span2 = span1.toBuilder().traceId("b").timestamp((TestObjects.TODAY + 2L) * 1000L).build();
        this.accept(span1, span2);
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("frontend").limit(1).build()).execute())).extracting(t -> ((Span)t.get(0)).id()).containsExactly((Object[])new String[]{span2.id()});
    }

    @Test
    protected void getTraces_endTsAndLookback() throws IOException {
        Span span1 = Span.newBuilder().traceId("a").id("1").timestamp((TestObjects.TODAY + 1L) * 1000L).localEndpoint(TestObjects.FRONTEND).build();
        Span span2 = span1.toBuilder().traceId("b").timestamp((TestObjects.TODAY + 2L) * 1000L).build();
        this.accept(span1, span2);
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY).build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY + 1L).build()).execute())).extracting(t -> ((Span)t.get(0)).id()).containsExactly((Object[])new String[]{span1.id()});
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY + 2L).build()).execute())).extracting(t -> ((Span)t.get(0)).id()).containsExactlyInAnyOrder((Object[])new String[]{span1.id(), span2.id()});
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY + 3L).build()).execute())).extracting(t -> ((Span)t.get(0)).id()).containsExactlyInAnyOrder((Object[])new String[]{span1.id(), span2.id()});
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY).build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY + 1L).lookback(1L).build()).execute())).extracting(t -> ((Span)t.get(0)).id()).containsExactly((Object[])new String[]{span1.id()});
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY + 2L).lookback(1L).build()).execute())).extracting(t -> ((Span)t.get(0)).id()).containsExactlyInAnyOrder((Object[])new String[]{span1.id(), span2.id()});
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY + 3L).lookback(1L).build()).execute())).extracting(t -> ((Span)t.get(0)).id()).containsExactlyInAnyOrder((Object[])new String[]{span2.id()});
    }

    @Test
    protected void traceWithManySpans() throws IOException {
        Object[] trace = new Span[101];
        trace[0] = Span.newBuilder().traceId("f66529c8cc356aa0").id("93288b4644570496").name("get").timestamp(TestObjects.TODAY * 1000L).duration(350000L).kind(Span.Kind.SERVER).localEndpoint(TestObjects.BACKEND).build();
        IntStream.range(1, trace.length).forEach(arg_0 -> ITSpanStore.lambda$traceWithManySpans$30((Span[])trace, arg_0));
        this.accept((Span[])trace);
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().build()).execute())).flatExtracting(t -> t).containsExactlyInAnyOrder(trace);
        Assertions.assertThat((List)((List)this.traces().getTrace(trace[0].traceId()).execute())).containsExactlyInAnyOrder(trace);
    }

    @Test
    protected void names_goLowercase() throws IOException {
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("frontend").remoteServiceName("BaCkEnD").build()).execute())).hasSize(1);
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("frontend").spanName("GeT").build()).execute())).hasSize(1);
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName("FrOnTeNd").build()).execute())).hasSize(1);
    }

    @Test
    protected void getTraces_endTsInsideTheTrace() throws IOException {
        this.accept(TestObjects.TRACE);
        Assertions.assertThat(ITSpanStore.sortTraces((List)this.store().getTraces(ITSpanStore.requestBuilder().endTs(TestObjects.TRACE_STARTTS + 100L).lookback(200L).build()).execute())).containsOnly((Object[])new List[]{TestObjects.TRACE});
    }

    void setupDurationData() throws IOException {
        Endpoint service1 = Endpoint.newBuilder().serviceName("service1").build();
        Endpoint service2 = Endpoint.newBuilder().serviceName("service2").build();
        Endpoint service3 = Endpoint.newBuilder().serviceName("service3").build();
        long offsetMicros = (TestObjects.TODAY - 3L) * 1000L;
        Span targz = Span.newBuilder().traceId("1").id(1L).name("targz").timestamp(offsetMicros + 100L).duration(200000L).localEndpoint(service1).remoteEndpoint(service3).putTag("lc", "archiver").build();
        Span tar = Span.newBuilder().traceId("1").id(2L).parentId(1L).name("tar").timestamp(offsetMicros + 200L).duration(150000L).localEndpoint(service2).remoteEndpoint(service2).putTag("lc", "archiver").build();
        Span gz = Span.newBuilder().traceId("1").id(3L).parentId(1L).name("gz").timestamp(offsetMicros + 250L).duration(50000L).localEndpoint(service3).remoteEndpoint(service1).putTag("lc", "archiver").build();
        Span zip = Span.newBuilder().traceId("3").id(3L).name("zip").timestamp(offsetMicros + 130L).duration(50000L).addAnnotation(offsetMicros + 130L, "zip").localEndpoint(service2).remoteEndpoint(service2).putTag("lc", "archiver").build();
        List<Span> trace1 = Arrays.asList(targz, tar, gz);
        List<Span> trace2 = Arrays.asList(targz.toBuilder().traceId("2").timestamp(offsetMicros + 110L).localEndpoint(service3).remoteEndpoint(service1).putTag("lc", "archiver-v2").build(), tar.toBuilder().traceId("2").timestamp(offsetMicros + 210L).localEndpoint(service2).remoteEndpoint(service2).putTag("lc", "archiver").build(), gz.toBuilder().traceId("2").timestamp(offsetMicros + 260L).localEndpoint(service1).remoteEndpoint(service2).putTag("lc", "archiver").build());
        List<Span> trace3 = Arrays.asList(zip);
        this.accept(trace1.toArray(new Span[0]));
        this.accept(trace2.toArray(new Span[0]));
        this.accept(trace3.toArray(new Span[0]));
    }

    protected static QueryRequest.Builder requestBuilder() {
        return QueryRequest.newBuilder().endTs(TestObjects.TODAY + TestObjects.DAY).lookback(TestObjects.DAY * 2L).limit(100);
    }

    private static /* synthetic */ void lambda$traceWithManySpans$30(Span[] trace, int i) {
        trace[i] = Span.newBuilder().traceId(trace[0].traceId()).parentId(trace[0].id()).id((long)i).name("foo").timestamp((TestObjects.TODAY + (long)i) * 1000L).duration(10L).localEndpoint(TestObjects.BACKEND).build();
    }
}

