/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.storage.ITStorage;
import zipkin2.storage.StorageComponent;

public abstract class ITServiceAndSpanNames<T extends StorageComponent>
extends ITStorage<T> {
    @Override
    protected final void configureStorageForTest(StorageComponent.Builder storage) {
    }

    @Test
    protected void getLocalServiceNames_includesLocalServiceName() throws Exception {
        Assertions.assertThat((List)((List)this.names().getServiceNames().execute())).isEmpty();
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.names().getServiceNames().execute())).containsOnly((Object[])new String[]{"frontend"});
    }

    @Test
    protected void getLocalServiceNames_noServiceName() throws IOException {
        this.accept(Span.newBuilder().traceId("a").id("a").build());
        Assertions.assertThat((List)((List)this.names().getServiceNames().execute())).isEmpty();
    }

    @Test
    protected void getRemoteServiceNames() throws Exception {
        Assertions.assertThat((List)((List)this.names().getRemoteServiceNames("frontend").execute())).isEmpty();
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.names().getRemoteServiceNames("frontend1").execute())).isEmpty();
        Assertions.assertThat((List)((List)this.names().getRemoteServiceNames("frontend").execute())).contains((Object[])new String[]{TestObjects.CLIENT_SPAN.remoteServiceName()});
    }

    @Test
    protected void getRemoteServiceNames_allReturned() throws IOException {
        List<Span> spans = IntStream.rangeClosed(0, 50).mapToObj(i -> {
            String suffix = i < 10 ? "0" + i : String.valueOf(i);
            return TestObjects.CLIENT_SPAN.toBuilder().id((long)(i + 1)).remoteEndpoint(Endpoint.newBuilder().serviceName("yak" + suffix).build()).build();
        }).collect(Collectors.toList());
        this.accept(spans);
        Assertions.assertThat((List)((List)this.names().getRemoteServiceNames("frontend").execute())).containsExactlyInAnyOrderElementsOf(spans.stream().map(Span::remoteServiceName)::iterator);
    }

    @Test
    protected void getRemoteServiceNames_dedupes() throws IOException {
        List<Span> spans = IntStream.rangeClosed(0, 50).mapToObj(i -> TestObjects.CLIENT_SPAN.toBuilder().id((long)(i + 1)).build()).collect(Collectors.toList());
        this.accept(spans);
        Assertions.assertThat((List)((List)this.names().getRemoteServiceNames("frontend").execute())).containsExactly((Object[])new String[]{TestObjects.CLIENT_SPAN.remoteServiceName()});
    }

    @Test
    protected void getRemoteServiceNames_noRemoteServiceName() throws IOException {
        this.accept(Span.newBuilder().traceId("a").id("a").localEndpoint(TestObjects.FRONTEND).build());
        Assertions.assertThat((List)((List)this.names().getRemoteServiceNames("frontend").execute())).isEmpty();
    }

    @Test
    protected void getRemoteServiceNames_serviceNameGoesLowercase() throws IOException {
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.names().getRemoteServiceNames("FrOnTeNd").execute())).containsExactly((Object[])new String[]{TestObjects.CLIENT_SPAN.remoteServiceName()});
    }

    @Test
    protected void getSpanNames_doesNotMapNameToRemoteServiceName() throws Exception {
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.names().getSpanNames(TestObjects.CLIENT_SPAN.remoteServiceName()).execute())).isEmpty();
    }

    @Test
    protected void getSpanNames() throws Exception {
        Assertions.assertThat((List)((List)this.names().getSpanNames("frontend").execute())).isEmpty();
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.names().getSpanNames("frontend1").execute())).isEmpty();
        Assertions.assertThat((List)((List)this.names().getSpanNames("frontend").execute())).contains((Object[])new String[]{TestObjects.CLIENT_SPAN.name()});
    }

    @Test
    protected void getSpanNames_allReturned() throws IOException {
        List<Span> spans = IntStream.rangeClosed(0, 50).mapToObj(i -> {
            String suffix = i < 10 ? "0" + i : String.valueOf(i);
            return TestObjects.CLIENT_SPAN.toBuilder().id((long)(i + 1)).name("yak" + suffix).build();
        }).collect(Collectors.toList());
        this.accept(spans);
        Assertions.assertThat((List)((List)this.names().getSpanNames("frontend").execute())).containsExactlyInAnyOrderElementsOf(spans.stream().map(Span::name)::iterator);
    }

    @Test
    protected void getSpanNames_dedupes() throws IOException {
        List<Span> spans = IntStream.rangeClosed(0, 50).mapToObj(i -> TestObjects.CLIENT_SPAN.toBuilder().id((long)(i + 1)).build()).collect(Collectors.toList());
        this.accept(spans);
        Assertions.assertThat((List)((List)this.names().getSpanNames("frontend").execute())).containsExactly((Object[])new String[]{TestObjects.CLIENT_SPAN.name()});
    }

    @Test
    protected void getSpanNames_noSpanName() throws IOException {
        this.accept(Span.newBuilder().traceId("a").id("a").localEndpoint(TestObjects.FRONTEND).build());
        Assertions.assertThat((List)((List)this.names().getSpanNames("frontend").execute())).isEmpty();
    }

    @Test
    protected void getSpanNames_serviceNameGoesLowercase() throws IOException {
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.names().getSpanNames("FrOnTeNd").execute())).containsExactly((Object[])new String[]{"get"});
    }
}

